import os
import sys
import platform
import subprocess
import re
from datetime import datetime
from pathlib import Path
import time
import zipfile
import tempfile
import shutil
import glob
import random
import colorama
from colorama import Fore, Style, Back

# Попытка импорта необходимых модулей
try:
    import yt_dlp
    import requests
except ImportError:
    print(Fore.YELLOW + "Установка необходимых модулей...")
    subprocess.check_call([sys.executable, '-m', 'pip', 'install', 'yt-dlp', 'requests'])
    import yt_dlp
    import requests

# Инициализация colorama
colorama.init(autoreset=True)

def extract_url(user_input):
    """Извлекает URL из HTML-кода встраивания"""
    match = re.search(r'(?:src|href)=[\'"](.*?)[\'"]', user_input)
    if match:
        url = match.group(1)
        if url.startswith('//'):
            return 'https:' + url
        return url
    return user_input

def download_ytdlp():
    """Скачивает yt-dlp.exe в папку скрипта при необходимости"""
    if not os.path.exists("yt-dlp.exe"):
        print(Fore.YELLOW + "Загрузка yt-dlp.exe...")
        url = "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp.exe"
        try:
            response = requests.get(url, timeout=10)
            response.raise_for_status()
            with open("yt-dlp.exe", "wb") as f:
                f.write(response.content)
            print(Fore.GREEN + "yt-dlp успешно загружен!")
            return True
        except Exception as e:
            print(Fore.RED + f"Ошибка загрузки yt-dlp: {e}")
            return False
    return True

def install_ffmpeg():
    """Устанавливает ffmpeg в папку скрипта"""
    print(Fore.YELLOW + "\n⚠️ FFmpeg не найден! Попытка установки...")
    
    try:
        script_dir = os.path.dirname(os.path.abspath(__file__))
        system = platform.system()
        
        if system == "Windows":
            ffmpeg_url = "https://github.com/BtbN/FFmpeg-Builds/releases/download/latest/ffmpeg-master-latest-win64-gpl.zip"
            temp_dir = tempfile.mkdtemp()
            zip_path = os.path.join(temp_dir, "ffmpeg.zip")
            
            print(Fore.CYAN + "Скачивание FFmpeg...")
            response = requests.get(ffmpeg_url, stream=True)
            with open(zip_path, 'wb') as f:
                for chunk in response.iter_content(chunk_size=8192):
                    f.write(chunk)
            
            print(Fore.CYAN + "Распаковка FFmpeg...")
            with zipfile.ZipFile(zip_path, 'r') as zip_ref:
                zip_ref.extractall(temp_dir)
            
            # Ищем все нужные исполняемые файлы
            for root, dirs, files in os.walk(temp_dir):
                for file in files:
                    if file.lower() in ['ffmpeg.exe', 'ffprobe.exe']:
                        shutil.copy(os.path.join(root, file), script_dir)
            
            print(Fore.GREEN + f"✅ FFmpeg установлен в: {script_dir}")
            return True
                
        elif system == "Linux":
            print(Fore.CYAN + "Установка FFmpeg через apt...")
            subprocess.run(['sudo', 'apt-get', 'install', '-y', 'ffmpeg'], check=True)
            return True
            
        elif system == "Darwin":
            print(Fore.CYAN + "Установка FFmpeg через brew...")
            subprocess.run(['brew', 'install', 'ffmpeg'], check=True)
            return True
            
    except Exception as e:
        print(Fore.RED + f"❌ Ошибка установки FFmpeg: {str(e)}")
        return False

def check_ffmpeg():
    """Проверяет наличие ffmpeg в системе или в папке скрипта"""
    script_dir = os.path.dirname(os.path.abspath(__file__))
    
    # Проверяем в папке скрипта
    if platform.system() == "Windows":
        if all(os.path.exists(os.path.join(script_dir, exe)) 
               for exe in ['ffmpeg.exe', 'ffprobe.exe']):
            return True
    
    # Проверяем в системном PATH
    try:
        subprocess.run(['ffmpeg', '-version'], 
                      stdout=subprocess.PIPE, 
                      stderr=subprocess.PIPE,
                      creationflags=subprocess.CREATE_NO_WINDOW if platform.system() == "Windows" else 0)
        return True
    except (FileNotFoundError, subprocess.CalledProcessError):
        return False

def get_random_user_agent():
    """Возвращает случайный User-Agent для обхода ограничений"""
    agents = [
        'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
        'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:89.0) Gecko/20100101 Firefox/89.0',
        'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.1 Safari/605.1.15',
        'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36',
        'Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.1 Mobile/15E148 Safari/604.1'
    ]
    return random.choice(agents)

def progress_hook(d):
    """Функция для отображения прогресса загрузки"""
    if d['status'] == 'downloading':
        percent = d.get('_percent_str', '0%').strip()
        speed = d.get('_speed_str', 'N/A')
        total_size = d.get('_total_bytes_str', '?')
        downloaded = d.get('_downloaded_bytes_str', '?')
        
        sys.stdout.write('\r' + ' ' * 80 + '\r')
        progress_str = Fore.YELLOW + f"Прогресс: {percent} | " + Fore.CYAN + f"Скорость: {speed} | " + Fore.MAGENTA + f"Размер: {downloaded}/{total_size}"
        sys.stdout.write(progress_str)
        sys.stdout.flush()
    
    elif d['status'] == 'finished':
        print(Fore.GREEN + "\n\n✅ Загрузка завершена! Начинается объединение потоков...")

def open_folder(path):
    """Автоматически открывает папку после скачивания"""
    try:
        if platform.system() == "Windows":
            os.startfile(path)
        elif platform.system() == "Darwin":
            subprocess.Popen(["open", path])
        else:
            subprocess.Popen(["xdg-open", path])
        print(Fore.BLUE + f"📂 Папка открыта: {path}")
    except Exception as e:
        print(Fore.RED + f"⚠️ Не удалось открыть папку: {str(e)}")

def set_file_creation_time(file_path):
    """Устанавливает текущее время создания/изменения файла"""
    try:
        current_time = time.time()
        os.utime(file_path, (current_time, current_time))
        print(Fore.CYAN + f"🕒 Время файла обновлено: {os.path.basename(file_path)}")
    except Exception as e:
        print(Fore.RED + f"⚠️ Не удалось обновить время файла: {str(e)}")

def move_to_videos_folder(file_path):
    """Перемещает файл в папку VideoSaved в Downloads"""
    try:
        # Создаем целевую папку
        target_folder = Path.home() / "Downloads" / "VideoSaved"
        target_folder.mkdir(parents=True, exist_ok=True)
        
        # Перемещаем файл
        target_path = target_folder / os.path.basename(file_path)
        shutil.move(file_path, target_path)
        
        print(Fore.BLUE + f"📂 Файл перемещен в: {target_path}")
        return target_path
    except Exception as e:
        print(Fore.RED + f"⚠️ Не удалось переместить файл: {str(e)}")
        return file_path

def print_header():
    """Печатает заголовок программы"""
    os.system('cls' if platform.system() == 'Windows' else 'clear')
    print(Fore.YELLOW + "=" * 70)
    print(Fore.CYAN + Style.BRIGHT + "🎬 КОНСОЛЬНЫЙ ЗАГРУЗЧИК ВИДЕО (на основе yt-dlp)")
    print(Fore.YELLOW + "=" * 70)
    print(Fore.GREEN + "Команды: " + Fore.WHITE + "[download]" + Fore.GREEN + " - загрузить видео, " + 
          Fore.WHITE + "[exit]" + Fore.GREEN + " - выход")
    print(Fore.YELLOW + "-" * 70)

def download_video():
    """Основная функция для загрузки видео"""
    # Получаем URL от пользователя
    user_input = input(Fore.CYAN + "\nВведите URL видео или команду: ").strip()
    
    # Проверка на команду выхода
    if user_input.lower() == 'exit':
        return False
    
    # Проверка пустого ввода
    if not user_input:
        print(Fore.RED + "Ошибка: Ввод не может быть пустым")
        return True
    
    # Извлекаем URL
    url = extract_url(user_input)
    print(Fore.BLUE + f"\n🔗 Извлеченный URL: {url}")
    
    # Создаем временную папку для скачивания в каталоге скрипта
    script_dir = os.path.dirname(os.path.abspath(__file__))
    temp_download_dir = os.path.join(script_dir, "temp_downloads")
    os.makedirs(temp_download_dir, exist_ok=True)
    print(Fore.BLUE + f"📂 Временная папка для скачивания: {temp_download_dir}")
    
    # Настройки для yt-dlp с улучшенной устойчивостью
    ydl_opts = {
        'format': 'bestvideo+bestaudio/best',
        'outtmpl': os.path.join(temp_download_dir, '%(title)s.%(ext)s'),
        'progress_hooks': [progress_hook],
        'merge_output_format': 'mkv',
        'noplaylist': True,
        'no_warnings': True,
        'quiet': False,
        'verbose': False,
        
        # Улучшения для обхода ограничений
        'retries': 10,  # Количество попыток переподключения
        'fragment_retries': 15,  # Попытки для фрагментов
        'skip_unavailable_fragments': True,  # Пропускать недоступные фрагменты
        'retry_sleep': 'exp=1:20',  # Экспоненциальная задержка между попытками
        'http_chunk_size': 10485760,  # Размер чанка 10MB
        'buffersize': 16384,  # Размер буфера
        'ratelimit': 2097152,  # Ограничение скорости (2 MB/s)
        
        # Случайный User-Agent для обхода блокировок
        'http_headers': {
            'User-Agent': get_random_user_agent(),
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
            'Accept-Language': 'en-US,en;q=0.5',
            'Connection': 'keep-alive',
        },
    }
    
    # Для Windows указываем путь к ffmpeg в папке скрипта
    if platform.system() == "Windows":
        if all(os.path.exists(os.path.join(script_dir, exe)) 
               for exe in ['ffmpeg.exe', 'ffprobe.exe']):
            ydl_opts['ffmpeg_location'] = script_dir
    
    try:
        print(Fore.MAGENTA + "\n🔍 Получение информации о видео...")
        
        # Получаем информацию о видео
        with yt_dlp.YoutubeDL({'quiet': True}) as ydl:
            info_dict = ydl.extract_info(url, download=False)
            filename = ydl.prepare_filename(info_dict)
            base_filename = os.path.basename(filename)
        
        # Проверяем, существует ли файл во временной папке
        temp_file_path = os.path.join(temp_download_dir, base_filename)
        if os.path.exists(temp_file_path):
            base, ext = os.path.splitext(base_filename)
            timestamp = datetime.now().strftime('%Y%m%d_%H%M%S')
            new_filename = f"{base}_{timestamp}{ext}"
            ydl_opts['outtmpl'] = os.path.join(temp_download_dir, f'%(title)s_{timestamp}.%(ext)s')
            print(Fore.YELLOW + f"\n⚠️ Внимание: Файл уже существует. Будет сохранен как: {new_filename}")
        
        print(Fore.GREEN + "\n🚀 Начинаю загрузку...")
        print(Fore.YELLOW + "=" * 70)
        
        # Загрузка видео
        with yt_dlp.YoutubeDL(ydl_opts) as ydl:
            result = ydl.download([url])
            
            if result == 0:
                # Ищем скачанный файл во временной папке
                downloaded_files = glob.glob(os.path.join(temp_download_dir, '*'))
                if downloaded_files:
                    # Берем самый новый файл
                    final_file = max(downloaded_files, key=os.path.getmtime)
                    
                    # Обновляем время создания файла
                    set_file_creation_time(final_file)
                    
                    # Перемещаем файл в папку VideoSaved
                    moved_file = move_to_videos_folder(final_file)
                    
                    print(Fore.YELLOW + "=" * 70)
                    print(Fore.GREEN + Style.BRIGHT + "\n✅ Видео успешно скачано и объединено!")
                    print(Fore.CYAN + f"💾 Файл сохранен как: {os.path.basename(moved_file)}")
                    
                    # Открываем папку с файлом
                    open_folder(os.path.dirname(moved_file))
                else:
                    print(Fore.RED + "\n❌ Не удалось найти скачанный файл во временной папке.")
            else:
                print(Fore.RED + "\n❌ Произошла ошибка при загрузке или объединении файлов.")
    
    except Exception as e:
        print(Fore.RED + f"\n❌ Произошла ошибка: {str(e)}")
        # Попробуем использовать yt-dlp.exe как fallback
        if platform.system() == "Windows" and os.path.exists("yt-dlp.exe"):
            print(Fore.YELLOW + "\nПопытка использовать yt-dlp.exe как fallback...")
            try:
                subprocess.run([
                    "yt-dlp.exe",
                    "-f", "bestvideo+bestaudio/best",
                    "--merge-output-format", "mkv",
                    "--output", os.path.join(temp_download_dir, "%(title)s.%(ext)s"),
                    url
                ], check=True)
                
                # Проверяем результат
                downloaded_files = glob.glob(os.path.join(temp_download_dir, '*'))
                if downloaded_files:
                    final_file = max(downloaded_files, key=os.path.getmtime)
                    set_file_creation_time(final_file)
                    moved_file = move_to_videos_folder(final_file)
                    print(Fore.GREEN + "\n✅ Видео успешно скачано с помощью yt-dlp.exe!")
                    open_folder(os.path.dirname(moved_file))
                else:
                    print(Fore.RED + "\n❌ Не удалось найти скачанный файл после использования yt-dlp.exe.")
            except Exception as ex:
                print(Fore.RED + f"\n❌ Ошибка при использовании yt-dlp.exe: {str(ex)}")
    
    # Очищаем временную папку
    try:
        for file in os.listdir(temp_download_dir):
            file_path = os.path.join(temp_download_dir, file)
            try:
                if os.path.isfile(file_path):
                    os.unlink(file_path)
            except Exception as e:
                print(Fore.RED + f"⚠️ Не удалось удалить временный файл: {str(e)}")
    except Exception as e:
        print(Fore.RED + f"⚠️ Не удалось очистить временную папку: {str(e)}")
    
    return True

def main():
    # Устанавливаем ffmpeg при необходимости
    if not check_ffmpeg():
        if not install_ffmpeg():
            print(Fore.RED + "\n❌ FFmpeg не установлен. Для работы программы требуется FFmpeg.")
            print(Fore.YELLOW + "Пожалуйста, установите его вручную:")
            print(Fore.CYAN + "Windows: https://www.gyan.dev/ffmpeg/builds/")
            print(Fore.CYAN + "Linux: sudo apt install ffmpeg")
            print(Fore.CYAN + "macOS: brew install ffmpeg")
            input(Fore.YELLOW + "\nНажмите Enter для выхода...")
            return
    
    # Основной цикл программы
    while True:
        print_header()
        
        # Скачиваем yt-dlp.exe для Windows
        if platform.system() == "Windows":
            if not download_ytdlp():
                print(Fore.YELLOW + "⚠️ Не удалось загрузить yt-dlp.exe, используется модуль Python")
        
        # Запускаем процесс загрузки
        if not download_video():
            break
        
        # Пауза перед следующим шагом
        print(Fore.YELLOW + "\n" + "=" * 70)
        input(Fore.GREEN + "\nНажмите Enter для продолжения...")

    # Прощальное сообщение
    print(Fore.MAGENTA + "\n" + "=" * 70)
    print(Fore.GREEN + Style.BRIGHT + "Спасибо за использование! До новых встреч!")
    print(Fore.MAGENTA + "=" * 70)
    time.sleep(2)

if __name__ == "__main__":
    main()
